<?php
/**
 *
 * @Packge      webteck 
 * @Author      Themeholy
 * @Author URL  https://themeforest.net/user/themeholy 
 * @version     1.0
 *
 */

/**
 * Enqueue style of child theme
 */
function webteck_child_enqueue_styles() {

    wp_enqueue_style( 'webteck-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'webteck-child-style', get_stylesheet_directory_uri() . '/style.css',array( 'webteck-style' ),wp_get_theme()->get('Version'));
}
add_action( 'wp_enqueue_scripts', 'webteck_child_enqueue_styles', 100000 );

function ti_custom_javascript() {
    ?>
	<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-element-bundle.min.js"></script>
        <script>
          jQuery(document).ready(function( $ ){
    		$('.th-social a').click(function(){
    		window.open(this.href, '_blank');
    		return false;
  		});
		$(".collapsible-btn").click(function(e) {
  			e.preventDefault();
  			var content = $(this).next(".collapsible-content");
 			$(this).parent(".collapsible-section").toggleClass('is-active');
  			$(content).toggle(250);
			
		});
		$('.tpg-post-holder .read-more a').addClass('line-btn');
		$('.wb_ps_single_item .wb_ps_readmore a').addClass('line-btn');
		$('.post-arrow .wbel-arrow').addClass('slider-arrow');
		$('.post-arrow .wb-arrow-next').addClass('slider-next');
		$('.brand-sec4 .brand-box').bind('click', false);
		$('.landing-services .service-box2 .box-title a').bind('click', false);
		$('.db-tab .th-btn').addClass('overview-form'); 
		$('.landing-header .header-logo a').bind('click', false);
	  });	
        </script>
    <?php
}
add_action('wp_head', 'ti_custom_javascript');

function validate_corporate_email($result, $tag) {
    $tag = new WPCF7_FormTag($tag);
    if ($tag->name !== 'your-email') {
        return $result;
    }
 	//echo 'Hi';	
    $email = isset($_POST['your-email']) ? sanitize_email($_POST['your-email']) : '';
    $blocked_domains = ['gmail.com', 'hotmail.com', 'outlook.com', 'yahoo.com'];
 
    // Extract domain from email
    $domain = substr(strrchr($email, "@"), 1);
 
    if (in_array($domain, $blocked_domains)) {
        $result->invalidate($tag, "Please enter a corporate/business email address.");
    } 
    return $result;
}
add_filter('wpcf7_validate_email*', 'validate_corporate_email', 10, 2);

// JavaScript to remove validation error on typing
add_action('wp_footer', function () {
    echo "<script>
        jQuery(document).ready(function($) {
            $('input[name=\"your-email\"]').on('input', function() {
                $(this).removeClass('wpcf7-not-valid'); // Remove error styling
                $(this).closest('.wpcf7-form-control-wrap').find('.wpcf7-not-valid-tip').remove(); // Remove error message
            });
        });
</script>";
});