<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Box Widget .
 *
 */
class Webteck_Service3 extends Widget_Base {

	public function get_name() {
		return 'webteckservices3';
	}
	public function get_title() {
		return __( 'Service New', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'servicesd_section',
			[
				'label' 	=> __( 'Service', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Service Style', 'webteck' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'webteck' ),
					'2'  		=> __( 'Style Two', 'webteck' ),
					'3'  		=> __( 'Style Three', 'webteck' ),
					'4'  		=> __( 'Style Four', 'webteck' ),
					'5'  		=> __( 'Style Five', 'webteck' ),
					'6'  		=> __( 'Style Six', 'webteck' ),
				]
			]
		);

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'image',
			[
				'label' 		=> esc_html__( 'Image', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::MEDIA,
				'default' 		=> [
					'url' =>  \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc', [
				'label' 		=> __( 'Description', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'services',
			[
				'label' 		=> __( 'Services', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '3']
				]

			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'desc', [
				'label' 		=> __( 'Features', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 6,
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 		=> esc_html__( 'Button Text', 'webteck' ),
				'type' 		=> \Elementor\Controls_Manager::TEXT,
		        'default'  	=> esc_html__( 'Read Details', 'webteck' ),
			]
		);
        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'webteck' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'webteck' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'services3',
			[
				'label' 		=> __( 'Services', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['4']
				]

			]
		);

		$repeater = new Repeater();

		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Fantasy Quest');
		webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', ''); 
		webteck_general_fields($repeater, 'tag', 'Tags', 'TEXT', '');
		webteck_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Learn More');
		webteck_url_fields($repeater, 'button_link', 'Button Link');
		
		$this->add_control(
			'services2',
			[
				'label' 		=> __( 'Service Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Fantasy Quest', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);


		$repeater = new Repeater();

		webteck_media_fields($repeater, 'image', 'Choose Image');
		webteck_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Fantasy Quest');
		webteck_general_fields($repeater, 'desc', 'Description', 'TEXTAREA', ''); 
		webteck_url_fields($repeater, 'button_link', 'Button Link');
		
		$this->add_control(
			'services5',
			[
				'label' 		=> __( 'Service Lists', 'webteck' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 	=> __( 'Fantasy Quest', 'webteck' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['5', '6']
				]
			]
		);
		
        $this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//
		webteck_common2_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .title', ['1', '2', '3', '6'], 'color', '--theme-color' );
		webteck_common2_style_fields($this, 'title3', 'Title', '{{WRAPPER}} h3', ['4'] );
		webteck_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .desc', ['1', '2', '3', '6'] );

       	//------Button Style-------
		webteck_button_style_fields( $this, '12', 'Button Styling', '{{WRAPPER}} .th-btn', ['1', '2', '4'] );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == '1' ){
        	echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="serviceSlider21" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['services'] as $data ) { 
                            echo '<div class="swiper-slide">';
                                echo '<div class="service_card7">';
                                    if( ! empty( $data['image']['url'] ) ){
                                        echo '<div class="box-icon">';
                                            echo webteck_img_tag( array(
                                                'url'   => esc_url( $data['image']['url'] ),
                                            ) );
                                        echo '</div>';
                                    }
                                    if( ! empty( $data['title'] ) ){
                                        echo '<h3 class="box-title title"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
                                    }
                                    if( ! empty( $data['desc'] ) ){
                                        echo '<p class="box-text desc">'.esc_html( $data['desc'] ).'</p>';
                                    }
                                    if( ! empty( $data['button_text'] ) ){
                                        echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn style2 style-radius">'.wp_kses_post($data['button_text']).'</a>';
                                    }
                                echo '</div>';
                            echo '</div> ';
                        }
                    echo '</div>';
                echo '</div>';
                echo '<button data-slider-prev="#serviceSlider21" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#serviceSlider21" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';
        	
	    }elseif( $settings['layout_style'] == '2' ){
			echo '<div class="row gy-4 justify-content-center">';
				foreach( $settings['services2'] as $data ) { 
					echo '<div class="col-md-6 col-xl-4">';
						echo '<div class="feature-card2">';
							if( ! empty( $data['tag'] ) ){
								echo '<span class="offer-feature"><span class="feature">'.esc_html( $data['tag'] ).'</span></span>';
							}
							if( ! empty( $data['image']['url'] ) ){
								echo '<div class="box-img">';
									echo webteck_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
								echo '</div>';
							}
							if( ! empty( $data['title'] ) ){
								echo '<h3 class="box-title title"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
							}
							if( ! empty( $data['desc'] ) ){
								echo '<p class="box-text desc">'.esc_html( $data['desc'] ).'</p>';
							}
							if( ! empty( $data['button_text'] ) ){
								echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn btn-gradient style-radius">'.wp_kses_post($data['button_text']).'</a>';
							}
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

	    }elseif( $settings['layout_style'] == '3' ){
			echo '<div class="slider-area">';
				echo '<div class="swiper th-slider has-shadow" id="serviceSlider22" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
					echo '<div class="swiper-wrapper">';
						$i = 0;
						foreach( $settings['services'] as $data ) { 
							$i++;
			        		$k = str_pad($i, 2, '0', STR_PAD_LEFT);
							echo '<div class="swiper-slide">';
								echo '<div class="service_card8">';
									echo '<div class="service-wrapp">';
										if( ! empty( $data['image']['url'] ) ){
											echo '<div class="box-icon">';
												echo webteck_img_tag( array(
													'url'   => esc_url( $data['image']['url'] ),
												) );
											echo '</div>';
										}
										echo '<span class="box-number">'.esc_html($k).'</span>';
									echo '</div>';
									if( ! empty( $data['title'] ) ){
										echo '<h3 class="box-title title"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
									}
									if( ! empty( $data['desc'] ) ){
										echo '<p class="box-text desc">'.esc_html( $data['desc'] ).'</p>';
									}
									if( ! empty( $data['button_text'] ) ){
										echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="line-btn style2 style-radius">'.wp_kses_post($data['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
									}
								echo '</div>';
							echo '</div>';
						}
					echo '</div>';
				echo '</div>';
				echo '<button data-slider-prev="#serviceSlider22" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
				echo '<button data-slider-next="#serviceSlider22" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
			echo '</div>';

		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="row gy-16">';
                echo '<div class="col-12">';
                    $i = 0;
					foreach( $settings['services3'] as $data ) { 
						$i++;
	                    echo '<div class="service-item3">';
	                        echo '<div class="service-wrapp">';
	                            echo '<div class="box-number">'.esc_html($i).'.</div>';
	                            echo '<div class="box-content">';
	                            	if( ! empty( $data['title'] ) ){
		                                echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
		                            }
		                            if( ! empty( $data['desc'] ) ){
		                                echo '<div class="box-list">';
		                                	echo wp_kses_post( $data['desc'] );
		                                echo '</div>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                        echo '<div class="service-button">';
	                        	if( ! empty( $data['button_text'] ) ){
		                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="th-btn btn-gradient2 style-radius">'.wp_kses_post($data['button_text']).'</a>';
		                        }
	                            echo '<a href="'.esc_url( $data['button_link']['url'] ).'" class="icon-btn"><img src="'.WEBTECK_PLUGDIRURI.'assets/img/shape/arrow-right.svg" alt=""></a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';

		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="row gy-4">';
				foreach( $settings['services5'] as $data ) { 
					echo '<div class="service-card5 tg-img-reveal-item" data-fx="1" data-img="'.esc_url( $data['image']['url'] ).'" style="">';
						if( ! empty( $data['title'] ) ){
							echo '<h3 class="box-title title"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
						}
						echo '<div class="service-wrapp">';
							if( ! empty( $data['desc'] ) ){
								echo '<div class="date desc">'.wp_kses_post( $data['desc'] ).'</div>';
							}
							if($data['button_link']['url']){
								echo '<a class="icon" href="'.esc_url( $data['button_link']['url'] ).'"><i class="fa-regular fa-arrow-up-right"></i></a>';
							}
						echo '</div>';
					echo '</div>';
				}
			echo '</div>';

		}elseif( $settings['layout_style'] == '6' ){
			foreach( $settings['services5'] as $data ) { 
				echo '<div class="service-box4">';
					if( ! empty( $data['image']['url'] ) ){
						echo '<div class="box-icon">';
							echo webteck_img_tag( array(
								'url'   => esc_url( $data['image']['url'] ),
							) );
						echo '</div>';
					}
					echo '<div class="box-content">';
						if( ! empty( $data['title'] ) ){
							echo '<h3 class="box-title title"><a href="'.esc_url( $data['button_link']['url'] ).'">'.esc_html( $data['title'] ).'</a></h3>';
						}
						if( ! empty( $data['desc'] ) ){
							echo '<p class="box-text desc">'.wp_kses_post( $data['desc'] ).'</p>';
						}
					echo '</div>';
				echo '</div>';

			}

		}


	}
}