<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Webteck_Animated_Shape extends Widget_Base {

	public function get_name() {
		return 'webteckshapeimage';
	}
	public function get_title() {
		return __( 'Animated Image V2', 'webteck' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'webteck' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'webteck' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        webteck_select_field( $this, 'layout_style', 'Layout Style', ['Style One', 'Style Two'] );

        $this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'webteck' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
                'condition'		=> [ 
					'layout_style' => [ '1']
				],
			]
		);
        $this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Safe Cleaning Supplies' , 'webteck' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['2']]
			]
		);
		$this->add_control(
			'effect_style',
			[
				'label' 		=> esc_html__( 'Add Styling Attributes', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT,
				'options' 		=> [
					'jump'  			=> esc_html__( 'Jump Effect', 'webteck' ),
					'jump-reverse'  	=> esc_html__( 'Jump Reverse Effect', 'webteck' ),
					'moving'  			=> esc_html__( 'Moving Effect', 'webteck' ),
					'movingX'  			=> esc_html__( 'Moving Reverse Effect(X)', 'webteck' ),
					'spin'			=> esc_html__( 'Spin Effect', 'webteck' ),
					'starani'			=> esc_html__( 'Starani Effect', 'webteck' ),
					'rotate-x'			=> esc_html__( 'Rotate Effect', 'webteck' ),
					''			=> esc_html__( 'No Effect', 'webteck' ),
				],
				'default' => [ 'jump'],
			]
		);
		$this->add_control(
			'from_top',
			[
				'label' 		=> __( 'Top', 'webteck' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
				],
			]
		);
		$this->add_control(
			'from_left',
			[
				'label' 		=> __( 'Left', 'webteck' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' 		=> [
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
					],
				],
				'default' => [
					'unit' => '%',
				],
			]
		);
		$this->add_control(
			'from_right',
			[
				'label' 		=> __( 'Right', 'webteck' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' 		=> [
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
					],
				],
				'default' => [
					'unit' => '%',
				],
			]
		);
		$this->add_control(
			'from_bottom',
			[
				'label' 		=> __( 'Bottom', 'webteck' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' 		=> [
					'%' 			=> [
						'min' 			=> 0,
						'max' 			=> 100,
					],
				],
				'default' => [
					'unit' => '%',
				],
			]
		);
		$this->add_control(
			'responsive_style',
			[
				'label' 		=> esc_html__( 'Responsive Styling', 'webteck' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> [
					'd-xxl-block'  		=> esc_html__( 'Hide From Extra large Device (xxl)', 'webteck' ),
					'd-xl-block'  		=> esc_html__( 'Hide From large Device (xl)', 'webteck' ),
					'd-lg-block'  		=> esc_html__( 'Hide From Tablet (lg)', 'webteck' ),
					'd-md-block'  		=> esc_html__( 'Hide From Mobile (md)', 'webteck' ),
					'd-sm-block'  		=> esc_html__( 'D Small Device (sm)', 'webteck' ),
					'd-none'  			=> esc_html__( 'Display None', 'webteck' ),
					' '  				=> esc_html__( 'Default', 'webteck' ),
				],
			]
		);
		$this->add_control(
			'wrap_class', [
				'label' 		=> __( 'Image Class Name', 'webteck' ),
				'description' 		=> __( 'Class name for image size control', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
			]
        );
		$this->add_control(
			'text_class', [
				'label' 		=> __( 'Text Class Name', 'webteck' ),
				'description' 		=> __( 'Class name for text size control', 'webteck' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'label_block' 	=> true,
                'condition'		=> [ 
					'layout_style' => [ '2']
				],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper','class','shape-mockup');
        $this->add_render_attribute('wrapper','class', $settings['wrap_class']);
        if($settings['layout_style'] == '2' ){
            $text_class = $settings['text_class'];
        }
        $this->add_render_attribute('wrapper','class', $settings['effect_style']);
        $this->add_render_attribute('wrapper','class', $settings['responsive_style']);

	    if($settings['from_top']['size']){
	        $this->add_render_attribute( 'wrapper', 'data-top', $settings['from_top']['size'] . $settings['from_top']['unit'] );
	    }
		if($settings['from_bottom']['size']){
	        $this->add_render_attribute( 'wrapper', 'data-bottom', $settings['from_bottom']['size'] . $settings['from_bottom']['unit'] );
	    }
	    if($settings['from_right']['size']){
	        $this->add_render_attribute( 'wrapper', 'data-right', $settings['from_right']['size'] . $settings['from_right']['unit'] );
	    }
	    if($settings['from_left']['size']){
	        $this->add_render_attribute( 'wrapper', 'data-left', $settings['from_left']['size'] . $settings['from_left']['unit'] );
	    }

        if($settings['layout_style'] == '1' ){
            if( !empty( $settings['image']['id'] ) ) {
                echo '<!-- Image -->';
                    echo '<div '.$this->get_render_attribute_string('wrapper').'>';
                        echo '<img src="'.esc_url( $settings['image']['url']).'" alt="'.esc_attr__('Shape Image', 'webteck').'" >';
                    echo '</div>';
                echo '<!-- End Image -->';
            }

        }elseif($settings['layout_style'] == '2' ){
            echo '<div '.$this->get_render_attribute_string('wrapper').'>';
                echo '<h4 class="'.esc_attr($text_class).'">'.esc_html($settings['title']).'</h4>';
            echo '</div>';

        }
		
	}
}